<?php
$questions = [
    ["image" => "img/swing.png", "correct" => "Buaian", "incorrect" => "Papan Gelongsor"],
    ["image" => "img/slides.png", "correct" => "Papan Gelongsor", "incorrect" => "Buaian"],
    ["image" => "img/see-saw.png", "correct" => "Jungkang-Jungkit", "incorrect" => "Gelongsor"],
    ["image" => "img/climbing.png", "correct" => "Alat Memanjat", "incorrect" => "Papan Gelongsor"],
    ["image" => "img/roundabout.png", "correct" => "Pusingan Gembira", "incorrect" => "Buaian"],
    ["image" => "img/sandbox.png", "correct" => "Kotak Pasir", "incorrect" => "Alat Memanjat"],
    ["image" => "img/monkeybars.jpg", "correct" => "Tiang Bergantung", "incorrect" => "Jungkang-Jungkit"],
    ["image" => "img/spring-rider.jpg", "correct" => "Haiwan Spring", "incorrect" => "Kotak Pasir"],
    ["image" => "img/rope-bridge.jpg", "correct" => "Jambatan Tali", "incorrect" => "Papan Gelongsor"],
    ["image" => "img/trampoline.jpeg", "correct" => "Trampolin", "incorrect" => "Papan Gelongsor"]
];

session_start();

// Reset the score at the start of the game or when required
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

// Check if it's the start of a new game
if (isset($_GET['reset_score']) && $_GET['reset_score'] == 'true') {
    $_SESSION['score'] = 0;  // Reset the score
}

$message = "";
$message_color = "";

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $selected_answer = $_POST['answer'];
    $correct_answer = $_POST['correct_answer'];
    
    if ($selected_answer == $correct_answer) {
        $_SESSION['score'] += 10; // Increase score by 10 for correct answer
        $message = "Tahniah! Jawapan kamu betul!";
        $message_color = "green";
    } else {
        $message = "Cuba lagi! Kamu pasti boleh!";
        $message_color = "red";
    }
    
    // Load next question
    $next_question = $_POST['question_index'] + 1;
    if ($next_question < count($questions)) {
        // Delay the redirection to allow message display
        echo "<script>
                setTimeout(function() {
                    window.location.href = 'game.php?question_index=" . $next_question . "';
                }, 1000); // 1 second delay
              </script>";
    } else {
        // Game Over, reset score, redirect to end.php with the current score
        echo "<script>
                setTimeout(function() {
                    window.location.href = 'end.php?score=" . $_SESSION['score'] . "&reset_score=true';
                }, 1000); // 1 second delay
              </script>";
    }
}

$question_index = isset($_GET['question_index']) ? $_GET['question_index'] : 0;
$current_question = $questions[$question_index];
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Taman</title>
    <link rel="stylesheet" href="style.css"> <!-- Pautkan ke fail CSS -->
</head>
<body class="end-body">
    <div class="end-container">
        <h1 class="end-title">Permainan Taman Permainan</h1>
        
        <div class="score">Skor: <?php echo $_SESSION['score']; ?>/100</div>

        <!-- Displaying the message for correct or incorrect answer -->
        <?php if ($message != ""): ?>
            <p style="color: <?php echo $message_color; ?>;"><?php echo $message; ?></p>
        <?php endif; ?>

        <!-- Settings button -->
        <button class="settings-btn" onclick="location.href='settings.php'">Tetapan</button>

        <div class="game-container">
            <center> <img src="<?php echo $current_question['image']; ?>" alt="Taman Permainan"></center>   
        </div>  

        <form method="POST" class="choices">
            <p>Apakah nama permainan ini?</p>
            <button type="submit" name="answer" value="<?php echo $current_question['correct']; ?>" class="choice-btn"><?php echo $current_question['correct']; ?></button>
            <button type="submit" name="answer" value="<?php echo $current_question['incorrect']; ?>" class="choice-btn"><?php echo $current_question['incorrect']; ?></button>

            <input type="hidden" name="correct_answer" value="<?php echo $current_question['correct']; ?>">
            <input type="hidden" name="question_index" value="<?php echo $question_index; ?>">
        </form>
    </div>
</body>
</html>
